/*
	myping.c:
		last updated in 99/4/20
		based on the source by R.Stevens
		edited by kalynda
*/

#include	"myping.h"

int	_datalen = 56;		/* data that goes with ICMP echo request */
int	_sd;			/* socket descriptor */
pid_t	_pid;			/* our PID */
struct sockaddr_in  _sasend;
struct sockaddr_in  _sarecv;

int
ping(char *addr)
{
        struct hostent  *he;
	int		size;
	int 		rv=0;

	_pid = getpid();
	signal(SIGALRM, sig_alrm);

        he = gethostbyname(addr);
	_sasend.sin_family = AF_INET;
	_sasend.sin_addr.s_addr = *(unsigned long*)(he->h_addr_list[0]);
        printf("ping'ing to %s\n", inet_ntoa(_sasend.sin_addr));

	if ((_sd = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0) {
		perror("socket()");
		return(-1);
	}
	setuid(getuid());	/* don't need special permissions any more */

	size = 60 * 1024;	/* OK if setsockopt fails */
	setsockopt(_sd, SOL_SOCKET, SO_RCVBUF, (char*)&size, sizeof(size));

	sig_alrm(SIGALRM);	/* send first packet */

//	for ( ; ; )
 {
		char	recvbuf[BUFSIZE];
		int	len;
		ssize_t	n;
		struct timeval	tval;

		len = sizeof(struct sockaddr_in);
		n = recvfrom(_sd, recvbuf, sizeof(recvbuf), 0, 
			(struct sockaddr*)&_sarecv, &len);
		if (n < 0) {
			if (errno == EINTR) ;
//				continue;
			else
				perror("recvfrom() in readloop.c");
		}
		gettimeofday(&tval, NULL);
		rv = proc_packet(recvbuf, n, &tval);
	}
	return(rv);
}

void
sig_alrm(int signo)
{
	send_packet();

	alarm(1);
	return;		/* probably interrupts recvfrom() */
}

unsigned short
in_cksum(unsigned short *addr, int len)
{
	int		nleft = len;
	int		sum = 0;
	unsigned short	*w = addr;
	unsigned short	answer = 0;

	while (nleft > 1)  {
		sum += *w++;
		nleft -= 2;
	}
	if (nleft == 1) {
		*(unsigned char *)(&answer) = *(unsigned char *)w ;
		sum += answer;
	}
	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	answer = ~sum;
	return(answer);
}

void
send_packet(void)
{
	char		sendbuf[BUFSIZE];
	int		len;
	struct icmp	*icmp;	/* <netinet/ip_icmp.h> */
	static		nsent = 0;

	icmp = (struct icmp *) sendbuf;
	icmp->icmp_type = ICMP_ECHO;
	icmp->icmp_code = 0;
	icmp->icmp_id = _pid;
	icmp->icmp_seq = nsent++;
	gettimeofday((struct timeval *) icmp->icmp_data, NULL);

	len = 8 + _datalen;		/* checksum ICMP header and data */
	icmp->icmp_cksum = 0;
	icmp->icmp_cksum = in_cksum((u_short *) icmp, len);

	sendto(_sd, sendbuf, len, 0, 
		(struct sockaddr*)&_sasend, sizeof(_sasend));
}

void
tv_sub(struct timeval *out, struct timeval *in)
{
	if ( (out->tv_usec -= in->tv_usec) < 0) {	/* out -= in */
		--out->tv_sec;
		out->tv_usec += 1000000;
	}
	out->tv_sec -= in->tv_sec;
}

int
proc_packet(char *ptr, ssize_t len, struct timeval *tvrecv)
{
	int		hlen1, icmplen;
	double		rtt;
	struct ip	*ip;
	struct icmp	*icmp;	/* <netinet/ip_icmp.h> */
	struct timeval	*tvsend;

	ip = (struct ip *) ptr;		/* start of IP header */
	hlen1 = ip->ip_hl << 2;		/* length of IP header */

	icmp = (struct icmp *) (ptr + hlen1);	/* start of ICMP header */
	if ( (icmplen = len - hlen1) < 8) {
		fprintf(stderr, "icmplen (%d) < 8", icmplen);
		return(-1);
	}

	if (icmp->icmp_type == ICMP_ECHOREPLY) {
		if (icmp->icmp_id != _pid)
			return;		/* not a response to our ECHO_REQUEST */
		if (icmplen < 16) {
			fprintf(stderr, "icmplen (%d) < 16", icmplen);
			return(-1);
		}

		tvsend = (struct timeval *) icmp->icmp_data;
		tv_sub(tvrecv, tvsend);
		rtt = tvrecv->tv_sec * 1000.0 + tvrecv->tv_usec / 1000.0;

		printf("%d bytes from %s: seq=%u, ttl=%d, rtt=%.3f ms\n",
				icmplen, inet_ntoa(_sarecv.sin_addr),
				icmp->icmp_seq, ip->ip_ttl, rtt);
		return(1);
	}
}

