<?php

class breadcrumb
{
	var $crumbs;
	var $known;
	var $pre;	/* depends/parents */
	
	function breadcrumb()
	{
		$this->crumbs = array(array("Main page", "/"));
		$this->known = array();
		
		$f = fopen("knowncrumbs.txt", "r");
		while($f && !feof($f))
		{
			$name = chop(fgets($f));
			$url = chop(fgets($f));
			
			$arr = explode("@", $name);
			$name = $arr[0];
			$pre = $arr[1];
			
			$this->known[$name] = $url;
			$this->pre[$name] = $pre;
		}
		fclose($f);
	}
	
	function add($name, $url = "")
	{
		$name = chop($name);
		$url = chop($url);
		
		if(!strlen($url))
		{
			if($this->known[$name]) 
			{
				$url = $this->known[$name];
				if($this->pre[$name])
				{
					$this->add($this->pre[$name]);
				}
			}
			else 
			{
				$name .= "[!]";
				$url = "URL NOT SUPPLIED!";
			}
		}
		array_push($this->crumbs, array($name, $url));
	}
	
	function markup()
	{
		$rv = "";
		$i = 0;
		
		foreach($this->crumbs as $crumb)
		{
			$rv .= "<a href=\"".$crumb[1]."\">".$crumb[0]."</a>\n";
			$i++;
			if($i < sizeof($this->crumbs)) $rv .= " / ";
		}
		
		return $rv;
	}
}
?>