#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <winuser.h>

#define GDEBUG
#include "debug.h"

static HWND fwin;				// Debugger server window
static HWND mywin;
static int DebuggerOperating;
static int StepMode=0;

void DoCheck(void)
{
	if(!IsWindow(fwin)) DebuggerOperating=0;
}

static HWND MyFindWindow(char* sname)
{
	HWND fwin;
	char wname[512];

	fwin=GetTopWindow(NULL);
	while(fwin)
	{
		GetWindowText(fwin, wname, 511);
		if(!strcmp(wname, sname)) break;
		fwin=GetNextWindow(fwin, GW_HWNDNEXT);
	}
	
	return fwin;
}

char* CutPath(char *fname)
{
	char *p;

	p=strrchr(fname, '\\');
	if(!p) p=fname;

	return p+1;
}

void MBox(char *msg)
{
	MessageBox(NULL, msg, "GDR!'s DeBugger", 0);
}


void DPing_(char *file, int line)
{
	DoCheck();
	if(StepMode)
	{
		int rv;

		rv=MessageBox(fwin, "Do you wish to continue single step mode?", "GDR!'s DeBugger", MB_YESNO | MB_DEFBUTTON1);
		if(rv==7) StepMode=0;	// No
		if(rv==6) {}			// Yes
	}
	
	if(fwin&&DebuggerOperating) 
	{
//		HKEY hkeyresult;
		COPYDATASTRUCT MyCDS;
		char msg[2049];
		sprintf(msg, "%s : %d", CutPath(file), line);

 /*		RegOpenKey ( HKEY_LOCAL_MACHINE, ( LPCTSTR ) "Software", &hkeyresult );
		RegSetValueEx ( hkeyresult, ( LPCTSTR )"DebugMessage" ,0, REG_SZ, ( const BYTE* )msg, strlen(msg)+1) ;
		RegCloseKey ( hkeyresult );
		SendMessage(fwin, WM_USER, (WPARAM) 6660, (LPARAM)0);
		*/

		MyCDS.lpData=&msg;
		MyCDS.cbData=sizeof(char[2049]);
		MyCDS.dwData=6660;
		SendMessage(fwin, WM_COPYDATA, (WPARAM) mywin, (LPARAM) (LPVOID) &MyCDS );

	}
}

int DSendMsg(char *msg)
{
	int rv=0;

	DoCheck();

	if(fwin&&DebuggerOperating) 
	{
/*		HKEY hkeyresult;

 		RegOpenKey ( HKEY_LOCAL_MACHINE, ( LPCTSTR ) "Software", &hkeyresult );
		RegSetValueEx ( hkeyresult, ( LPCTSTR )"DebugMessage" ,0, REG_SZ, ( const BYTE* )msg, strlen(msg)+1) ;
		RegCloseKey ( hkeyresult );
		SendMessage(fwin, WM_USER, (WPARAM) 666, (LPARAM)0);
		rv=1;
		*/

		char str[1024];
		COPYDATASTRUCT MyCDS;

		strcpy(str, msg);
		MyCDS.lpData=&str;
		MyCDS.cbData=sizeof(char[1024]);
		MyCDS.dwData=666;
		SendMessage(fwin, WM_COPYDATA, (WPARAM) mywin, (LPARAM) (LPVOID) &MyCDS );


	}
	else rv=0;

	return rv;
}

void DShutDown(void)
{
	DSendMsg("Abnormal program termination. Shutting down...");
	ShutdownDebugger();
	abort();
}

void DS_(char *vname, char *v, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=\"%s\"", CutPath(file), line, vname, v);
	DSendMsg(destmsg);
}

void D_(char *msg, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s", CutPath(file), line, msg);
	DSendMsg(destmsg);
}

void DError_(char *msg, char *file, int line)
{
	char destmsg[2048];

	sprintf(destmsg, "ERROR: %s", msg);
	D_(msg, file, line);
}

void D1_(char *v1n, int v1, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%d ($%x)", CutPath(file), line, v1n, v1, v1);
	DSendMsg(destmsg);
}

void D2_(char *v1n, int v1, char *v2n, int v2, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%d ($%x) | %s=%d ($%x)", CutPath(file), line, v1n, v1, v1, v2n, v2, v2);
	DSendMsg(destmsg);
}

void D3_(char *v1n, int v1, char *v2n, int v2, char *v3n, int v3, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%d ($%x) | %s=%d ($%x) | %s=%d ($%x)", CutPath(file), line, v1n, v1, v1, v2n, v2, v2, v3n, v3, v3);
	DSendMsg(destmsg);
}

void D4_(char *v1n, int v1, char *v2n, int v2, char *v3n, int v3, char *v4n, int v4, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%d ($%x) \t| %s=%d ($%x) \t| %s=%d ($%x) \t| %s=%d ($%x)", CutPath(file), line, v1n, v1, v1, v2n, v2, v2, v3n, v3, v3, v4n, v4, v4);
	DSendMsg(destmsg);
}

void DF_(char *v1n, float v1, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%f", CutPath(file), line, v1n, v1);
	DSendMsg(destmsg);
}

void DD_(char *v1n, double v1, char *file, int line)
{
	char destmsg[2048];

	DPing_(file, line);
	sprintf(destmsg, "(%s : %d)\t %s=%f", CutPath(file), line, v1n, v1);
	DSendMsg(destmsg);
}


void Assert_(char *condn, int cond, char *file, int line)
{
	char askbuf[2048];
	int retv;

	DPing_(file, line);
	if(cond) return;
	
	/* ...else... */
	sprintf(askbuf, "(%s : %d) ASSERTION FAILED!\t Condition: %s ", CutPath(file), line, condn);
	DSendMsg(askbuf);

	sprintf(askbuf, "ASSERTION FAILED!\nFile: %s\nLine: %d\nCondition: %s\nDo you wish to switch to step mode?\n(Cancel = abort execution)\n", CutPath(file), line, condn);
	retv=MessageBox(fwin, askbuf, "ASSERTION FAILURE", MB_YESNOCANCEL | MB_ICONEXCLAMATION | MB_DEFBUTTON1);
	if(retv==2) DShutDown();	// cancel
	if(retv==7) return;		// no (ignore)
	if(retv==6) StepMode=1;	// yes
	return;
}

int dprintf(const char *format, ...)
{
#ifdef GDEBUG
	char dbuf[512];
	int rv;
	
	va_list ap;
		
	va_start(ap, format);
	rv=vsprintf(dbuf, format, ap);
	
	DSendMsg(dbuf);
	return rv;
#endif
}

int CheckPointer_(char *name, void *ptr, char *file, int line)
{
	char askbuf[2048];
	int retv;

	DPing_(file, line);
	if(ptr) return TRUE;

	/* ... else... */

	sprintf(askbuf, "(%s : %d)\t POINTER CHECK FAILED! Name: %s ", CutPath(file), line, name);
	DSendMsg(askbuf);

	sprintf(askbuf, "POINTER CHECK FAILED!\nFile: %s\nLine: %d\nName: %s\nDo you wish to switch to step mode?\n(Cancel = abort execution)\n", CutPath(file), line, name);
	retv=MessageBox(fwin, askbuf, "POINTER CHECK FAILURE", MB_YESNOCANCEL | MB_ICONEXCLAMATION | MB_DEFBUTTON1);
	if(retv==2) DShutDown();		// cancel
	if(retv==7) return 0;		// no (ignore)
	if(retv==6) StepMode=1;		// yes
	return 0;
}

int InitDebugger(HINSTANCE hInstance)
{
	fwin=MyFindWindow("Debug Window   [http://www.GDR.w.pl/]");

	if(fwin) 
	{
		mywin=CreateWindow("DClient", NULL, WS_POPUP, 0, 0, 10,10, NULL, NULL, hInstance, NULL);
		DebuggerOperating=1;
		DSendMsg("Client connected.");
	}
	else
	{
		DebuggerOperating=0;
	}
	return DebuggerOperating;
}

void ShutdownDebugger(void)
{
	char buf[2048];
	char buf2[2200];
	DSendMsg("Client disconnected");
	GetWindowText(fwin, buf, 2048);
	sprintf(buf2, "Last line executed: %s", buf);
	DSendMsg(buf2);
	DebuggerOperating=0;
	CloseWindow(mywin);
	SetWindowText(fwin, "Debug Window   [http://www.GDR.w.pl/]");
}
