int InitDebugger(HINSTANCE);
void ShutdownDebugger(void);

#ifdef MYDEBUG

void DPing_(char *file, int line);
void DS_(char *vname, char *v, char *file, int line);
void D_(char *msg, char *file, int line);
void DError_(char *msg, char *file, int line);
void D1_(char *v1n, int v1, char *file, int line);
void D2_(char *v1n, int v1, char *v2n, int v2, char *file, int line);
void D3_(char *v1n, int v1, char *v2n, int v2, char *v3n, int v3, char *file, int line);
void D4_(char *v1n, int v1, char *v2n, int v2, char *v3n, int v3, char *v4n, int v4, char *file, int line);



#define d(x) D_(#x, __FILE__, __LINE__)
#define ds(x) DS_(#x, x, __FILE__, __LINE__)
#define ping() DPing_(__FILE__, __LINE__)
#define d1(x) D1_(#x, x, __FILE__, __LINE__)
#define d2(x,y) D2_(#x, x, #y, y, __FILE__, __LINE__)
#define d3(x,y,z) D3_(#x, x, #y, y, #z, z, __FILE__, __LINE__)
#define d4(x,y,z,q) D4_(#x, x, #y, y, #z, z, #q, q, __FILE__, __LINE__)

#else

#define d(x) ((void)0)
#define ds(x) ((void)0)
#define ping() ((void)0)
#define d1(x) ((void)0)
#define d2(x,y) ((void)0)
#define d3(x,y,b) ((void)0)
#define d4(x,b,g,t) ((void)0)

#endif