#!/usr/bin/python

"""
pyJabberShell 0.1 by GDR! (http://gdr.prv.pl/)

An Unix shell available via Jabber!
Requires: Python, pexpect (http://pexpect.sourceforge.net/), Unix with shell

Don't run interactive programs like mc (or you will die)
"""

import os
import re
import time
import jabber
import xmlstream
import pexpect

## The jabber login you created for pyJabberShell
#jablogin = "loginprogramu"

## The password of pyJabberShell jabber account
#jabpass = "hasloprogramu"

## The jabbber server where the account was created
#jabserv = "servprogramu"

## Tuple of JIDs allowed to execute commands
#jabremote = ["twoj JID", "JID twojego psa"]

## Shell to be available to Jabber
SHELL = "/bin/sh -s"


jablogin = "gdrshell"
jabpass = "shell"
jabserv = "jabberpl.org"
jabremote = ["gdr@generatedcontent.com", "usms@chrome.pl"]


jab = None
sh = None
poll = None
p = None
queue = []
esc = re.compile('\033\[.?.?.?.?.?m|\033\[[A-Z]|\033.B|\033\[.J|\033.?.?.?.?.?H')
jid = re.compile('(.*)/.*')
logfile = open("jabbershell.log", "a")

def log(text):
	line = str(time.time())
	line += "\t"
	line += text
	line += "\r\n"
	logfile.write(line)

def ph(w00t, obj):
	pass

def mh(w00t, obj):
	"""
	['__doc__', '__init__', '__module__', '__repr__', '__str__', '_node', '_xmlnode2str', 'asNode', 'attrs', 'buildReply', 'build_reply', 'data', 'fromTo', 'getAttr', 'getBody', 'getChildren', 'getData', 'getDataAsParts', 'getError', 'getErrorCode', 'getFrom', 'getID', 'getName', 'getNamespace', 'getParent', 'getSubject', 'getTag', 'getTags', 'getThread', 'getTimestamp', 'getTo', 'getType', 'getX', 'getXNode', 'getXNodes', 'getXPayload', 'insertData', 'insertNode', 'insertTag', 'insertXML', 'kids', 'name', 'namespace', 'parent', 'putAttr', 'putData', 'removeTag', 'setBody', 'setError', 'setFrom', 'setID', 'setName', 'setNamespace', 'setParent', 'setSubject', 'setThread', 'setTimestamp', 'setTo', 'setType', 'setX', 'setXNode', 'setXPayload', 'time_stamp']
	"""
#	print "From:", obj.getFrom()
	j = re.match('(.*)/.*', str(obj.getFrom()))
	if jabremote.count(j.group(1)) == 0:
		jab.send(obj.buildReply("Access denied for JID " + str(obj.getFrom())))
		log("Access denied for JID " + str(obj.getFrom()) + " trying " + str(obj.getBody()) )
		return
		
	sender = j.group(1)
	body = obj.getBody()
	
	if(body == None):
		return
		
	if sh == None:
		print "No shell"
		return
		
	if body != '`':
		if body == "^C":
			body = "\03"
		elif body == "^Z":
			body = "\032"
		elif body == "\\t":
			sh.send("\t")
			body = None
		if body:
			sh.sendline(body)	
			log(str(obj.getFrom()) + " executed " + body)
	reply = ""
	try:
#	if True:
		while True:
			time.sleep(0.1)
			part = sh.read_nonblocking(size=40000, timeout=0)
			reply += part
	except:
		pass
			
	reply = esc.sub('', reply)
#	term = ANSI.ANSI()
#	term.write(reply)
#	reply = str(term)
	reply = xmlstream.XMLescape(reply)
	s = open("out", "w")
	s.write(reply)
	s.close()
#	print reply
#	jab.send(obj.buildReply(reply))
	lines = reply.splitlines()
	for i in range(0, len(lines) / 10):
		msg = ""
		for j in range(10*i, 10*i+10):
			msg += lines[j] + "\n"
		queue.append("""
<message to="%s" type="chat" id="137">
<body>%s</body>
<active xmlns="http://jabber.org/protocol/chatstates" />
<x xmlns="jabber:x:event">
<composing />
</x>
</message>""" % (sender, msg))

	msg = ""	
	for j in range(10*(len(lines) / 10), len(lines)):
		msg += lines[j] + "\n"
	queue.append("""
<message to="%s" type="chat" id="137">
<body>%s</body>
<active xmlns="http://jabber.org/protocol/chatstates" />
<x xmlns="jabber:x:event">
<composing />
</x>
</message>""" % (sender, msg))

	print "Finished processing:", body
	
jab = jabber.Client(host=jabserv, port=5222, connection=xmlstream.TCP, debug=[], log=0) #_SSL
jab.setPresenceHandler(ph)
jab.setMessageHandler(mh)
try:
   jab.connect()
except Exception, e:
   raise "ConnectionError", "Couldn't connect: %s" % str(e)
else:
   print "Connected"

if jab.auth(jablogin, jabpass, "res"):
	print "Authenticated"
else:
	raise "Auth failed", (self.JabberConn.lastErr, self.JabberConn.lastErrCode)

sh = pexpect.spawn(SHELL)
sh.sendline("set TERM=dumb")
sh.sendline("set PAGER=cat")

jab.sendInitPresence()
jab.requestRoster()

jab.process()

# Yes, I know, the standard conformance kills... but hey, it's a hack!
for client in jabremote:
	jab.send("""
<message to="%s" type="chat" id="137">
<body>pyJabberConsole ready</body>
<active xmlns="http://jabber.org/protocol/chatstates" />
<x xmlns="jabber:x:event">
<composing />
</x>
</message>""" % client)

while(1):
	jab.process()
	if len(queue):
		jab.send(queue[0])
		queue = queue[1:]
	
